 #include"stdio.h"
 #include"graphic.h"
 #include"math.h"
 #include"sound.h"
 #include"scale.h"
 
 #define MAXNOTE  16
 #define FRET    150
 #define ROW      16
 #define COLUMN    2
 #define DIST     15
 #define XSTAFF   40
 #define YSTAFF  160
 
 int    notenum;
 int    choice[5];
 int    x, y, z, k;
 char   c;
 int    staff[MAXNOTE];
 
 
 int    fingers[ROW][COLUMN] =    23, 150 ,   /* g */
                                   23, 120 ,   /* a */
                                   23,  90 ,   /* b */
                                   23,  76 ,   /* c */
                                   26, 150 ,   /* d */
                                   26, 120 ,   /* e */
                                   26,  104 ,  /* f */
                                   26,  76 ,   /* g */
                                   29, 150 ,   /* a */
                                   29, 120 ,   /* b */
                                   29,  104 ,  /* c */
                                   29,   76 ,  /* d */
                                   32, 150 ,   /* e */
                                   32, 134 ,   /* f */
                                   32,  104 ,  /* g */
                                   32,  76  ; /* a */
 
 
 
 
 main()
 
 void   inst();
 void   board();
 void   scheme();
 void   strings();
 void   draw_staff();
 void   display();
 void   play();
 void   show();
 void   put_note();
 void   point();
 
 inst();
 
 getchar();
 
 /*     SETUPGRAFIX   */
 
 graphic();
 graphon();
 backgr(14,1);
 clrmap(0);
 colors(0, 13, 4);
 
 board(); strings(); scheme(); draw_staff();
 
 voice1.lh_pulse=159;               /*  lower half of pulse width value        */
 voice1.uh_pulse=31;                /*  upper half of pulse width value        */
 voice1.waveform=33;                /*  waveform control register              */
 voice1.atck_dcay=9;                /*  attack and decay control register      */
 voice1.sus_rel=224;                /*  sustain and release control register   */
 
 voice2.lh_pulse=159;               /*  lower half of pulse width value        */
 voice2.uh_pulse=31;                /*  upper half of pulse width value        */
 voice2.waveform=277;               /*  waveform control register              */
 voice2.atck_dcay=9;                /*  attack and decay control register      */
 voice2.sus_rel=224;                /*  sustain and release control register   */
 
 voice3.lh_pulse=225;               /*  lower half of pulse width value        */
 voice3.uh_pulse=0;                 /*  upper half of pulse width value        */
 voice3.waveform=65;                /*  waveform control register              */
 voice3.atck_dcay=9;                /*  attack and decay control register      */
 voice3.sus_rel=20;                 /*  sustain and release control register   */
 
 voice2.lh_tone=0;
 voice2.uh_tone=0;
 
 voice3.lh_tone=0;
 voice3.uh_tone=0;
 
 filter.lh_cutoff=11;                   /*  lower half of cut-off filter       */
 filter.uh_cutoff=33;                   /*  upper half of cut-off filter       */
 filter.res_sound=154;                  /*  resonance and sound filtering      */
 filter.mode_vol=0;                     /*  mode and volume controls           */
 
 notenum=1;
 
 while((c=getchar())!='x')
 
    if((c=getchar())=='d')display();
 
    if((c=getchar())=='p')play();
 
    if((c=getchar())=='s')show();
 
    if((c=getchar())=='+') notenum++; if(notenum>3) notenum=4; 
    if((c=getchar())=='-') notenum--; if(notenum<2) notenum=1; 
 
    if((c=getchar())=='c')
       printf("%c", CLR);
       clrmap(0);
       board(); strings(); scheme();  draw_staff();
       
 
   /*  end while()  */
 
   /*  end main    ************************************************************/
 
 
 /*     DISPLYLISTOFCOMMANDS     ********************************************/
 void   inst()
 
 printf("%c",'\037');
 printf("%c%c  Write down these commands; character\n", CLR, HOME );
 printf("mode will be disabled during GrAfIx MoDe\n\n\n");
 printf("d: Display notes on the staff.\n");
 printf("p: Play the tones indicated\n   on the staff.\n");
 printf("s: Show the location of the notes\n   on the ");
 printf("violin finger board.\n");
 printf("c: Clear screen\n");
 printf("+: Increases number of notes, up to 4.\n");
 printf("-: Decreases number of notes.\n");
 printf("x: EXIT from the program.\n");
 printf("\n Commands can be repeated. \n");
 printf("\n Please e-mail responses to James Britt\n");
 printf(" on CompuServe:  73417,2776.\n");
 printf("\n        HAVEFUN!\n ENTERANYTHINGTOGETSTARTED!\n\n");
 
 return;
 
   /*  end inst()  ************************************************************/
 
 /*     DRAWFINGERBOARD      **************************************************/
 
 void board()
 
 
 setcol(2);
 shape(21, FRET, 34, 20);
 /*
 setcol(3);
 
 shape(21,FRET,34,FRET-DIST+1);
 shape(21,FRET-(2*DIST),34,FRET-(3*DIST-1));
 shape(21,FRET-(4*DIST),34,FRET-(5*DIST-1));
 shape(21,FRET-(6*DIST),34,FRET-(7*DIST-1));
   */
 return;
 
   /*  end board()    *********************************************************/
 
 
 /*     DRAWSTRINGS       *****************************************************/
 
 void strings()
 
 
 setcol(1);
 line(23,-2,23,150);
 line(26,-2,26,150);
 line(29,-2,29,150);
 line(32,-2,32,150);
 
 return;
 
   /*  end strings()   ********************************************************/
 
 /*     SHOWFINGERINGSCHEMEONBOARD              ****************************/
 void scheme()
 
 int    x, y, r;
 setcol(0);
 
    for(r=0; r<ROW+1; r++)
 
    x=fingers[r][0];
    y=fingers[r][1];
 
    dot(x, y+2); dot(x-1, y+1);
    dot(x-1, y); dot(x-1, y-1);
    dot(x, y-2); dot(x+1, y-1);
    dot(x+1, y); dot(x+1, y+1);
    
 return;
 
   /*  end scheme()  **********************************************************/
 
 /*      DRAWSTAFF         ****************************************************/
 
 
 void draw_staff()
 
 setcol(1);
 for(k=0; k<5; k++ )
    setplot(XSTAFF, YSTAFF + k*6 );
    plot(150, YSTAFF + k*6 );
    
 
 line(XSTAFF, YSTAFF, XSTAFF, YSTAFF + 24 );
 line(150, YSTAFF, 150, YSTAFF + 24 );
 /* line((XSTAFF+150)/2,  YSTAFF, (XSTAFF+150)/2 , YSTAFF + 24 );  */
 
 return;
 
  /*   end draw_staff()      **********************************/
 
 
 /*     DISPLAYNOTESONTHESTAFF  ********************************************/
 void   display()
 
 int    k;
 int    dist;
 
 dist = (150-XSTAFF)/5;
 
 for(k=0; k<notenum; k++)
    choice[k]  = (((int)(rnd(0)*2196))%MAXNOTE)    ;
    put_note( XSTAFF+dist*(1+k), (YSTAFF-15)+3*choice[k] );
    
 return;
 
   /*  end display()   ********************************************************/
 
 /*     PLAYNOTESSHOWNONSTAFF   ********************************************/
 
 void   play()
 
 
 int    q, x;
 int    dist;
 
 dist = (150-XSTAFF)/5;
 
 for(x=0; x<notenum; x++)
 
    filter.mode_vol = 0;
 
    switch(choice[x])
 
        case  0 :    voice1.lh_tone = note[_G_ oct4][lower];
                     voice1.uh_tone = note[_G_ oct4][upper];
                     break;
 
        case  1 :    voice1.lh_tone = note[_A_ oct4][lower];
                     voice1.uh_tone = note[_A_ oct4][upper];
                     break;
 
        case  2 :    voice1.lh_tone = note[_B_ oct4][lower];
                     voice1.uh_tone = note[_B_ oct4][upper];
                     break;
 
        case  3 :    voice1.lh_tone = note[_C_ oct5][lower];
                     voice1.uh_tone = note[_C_ oct5][upper];
                     break;
 
        case  4 :    voice1.lh_tone = note[_D_ oct5][lower];
                     voice1.uh_tone = note[_D_ oct5][upper];
                     break;
 
        case  5 :    voice1.lh_tone = note[_E_  oct5][lower];
                     voice1.uh_tone = note[_E_  oct5][upper];
                     break;
 
        case  6 :    voice1.lh_tone = note[_F_ oct5][lower];
                     voice1.uh_tone = note[_F_ oct5][upper];
                     break;
 
        case  7 :    voice1.lh_tone = note[_G_ oct5][lower];
                     voice1.uh_tone = note[_G_ oct5][upper];
                     break;
 
        case  8 :    voice1.lh_tone = note[_A_ oct5][lower];
                     voice1.uh_tone = note[_A_ oct5][upper];
                     break;
 
        case  9 :    voice1.lh_tone = note[_B_ oct5][lower];
                     voice1.uh_tone = note[_B_ oct5][upper];
                     break;
 
        case 10 :    voice1.lh_tone = note[_C_ oct6][lower];
                     voice1.uh_tone = note[_C_ oct6][upper];
                     break;
 
        case 11 :    voice1.lh_tone = note[_D_ oct6][lower];
                     voice1.uh_tone = note[_D_ oct6][upper];
                     break;
 
        case 12 :    voice1.lh_tone = note[_E_ oct6][lower];
                     voice1.uh_tone = note[_E_ oct6][upper];
                     break;
 
        case 13 :    voice1.lh_tone = note[_F_ oct6][lower];
                     voice1.uh_tone = note[_F_ oct6][upper];
                     break;
 
        case 14 :    voice1.lh_tone = note[_G_ oct6][lower];
                     voice1.uh_tone = note[_G_ oct6][upper];
                     break;
 
        case 15 :    voice1.lh_tone = note[_A_ oct6][lower];
                     voice1.uh_tone = note[_A_ oct6][upper];
                     break;
 
        default :    break;
 
           /* end switch  */
 
    voice2.lh_tone = voice1.lh_tone;
    voice2.uh_tone = voice1.uh_tone;
 
    voice3.lh_tone = voice1.lh_tone;
    voice3.uh_tone = voice1.uh_tone;
 
    filter.mode_vol=15;
 
    setcol(0);
    put_note( XSTAFF+dist*(1+x), (YSTAFF-15)+3*choice[x] );
    setcol(1);
 
    point(x);
 
    for(q=0; q<1000; q++);
 
    filter.mode_vol=0;
    setcol(1);
    put_note( XSTAFF+dist*(1+x), (YSTAFF-15)+3*choice[x] );
    setcol(0);
    point(x);
 
     /* end for(choice[] )   */
 
 
 return;
 
   /*  end play    ************************************************************/
 
 
 /*     SHOWLOCATIONOFNOTESONFINGERBOARD      ****************************/
 void   show()
 
 
 
 int    x, y, n;
 setcol(3);
 
 for(n=0;n<notenum;n++)
 
    x=fingers[choice[n]][0];
    y=fingers[choice[n]][1];
 
    dot(x, y+2); dot(x-1, y+1);
    dot(x-1, y); dot(x-1, y-1);
    dot(x, y-2); dot(x+1, y-1);
    dot(x+1, y); dot(x+1, y+1);
    
 
 return;
 
   /*  end show    ************************************************************/
 
 /*     POINTTOFINGERBOARDLOCATION      ************************************/
 
 void point(n)
 int    n;
 
 int    x, y;
 
    x=fingers[choice[n]][0];
    y=fingers[choice[n]][1];
 
    dot(x, y+2); dot(x-1, y+1);
    dot(x-1, y); dot(x-1, y-1);
    dot(x, y-2); dot(x+1, y-1);
    dot(x+1, y); dot(x+1, y+1);
    return;
          /* end point()   ****************************************************/
 
 
 
 /*      PUTNOTESYMBOLATLOCATIONX/YONSTAFF   ****************************/
 void   put_note(x, y)
 
 int    x, y;
 
 
 int    n, num;
 
    dot(x, y+2); dot(x-1, y+1);
    dot(x-1, y); dot(x-1, y-1);
    dot(x, y-2); dot(x+1, y-1);
    dot(x+1, y); dot(x+1, y+1);
 
 if(y<YSTAFF-1)
 
    switch(YSTAFF-y)
 
        case 6:  num = 2; break;
        case 9:  num = 2; break;
        case 12: num = 3; break;
        case 15: num = 3; break;
        case 18: num = 4; break;
        
 
    for(n = 1; n<num; n++)
        line(x-3, YSTAFF-6*n, x+3, YSTAFF-6*n);
    
 if(y>YSTAFF+27)
        line(x-3, YSTAFF+30, x+3, YSTAFF+30 );
 
 
 return;
 
 
 
 /******************************************************************************/
 